const {
  default: makeWASocket,
  MessageType,
  MessageOptions,
  Mimetype,
  DisconnectReason,
  BufferJSON,
  AnyMessageContent,
  delay,
  fetchLatestBaileysVersion,
  isJidBroadcast,
  makeCacheableSignalKeyStore,
  makeInMemoryStore,
  MessageRetryMap,
  useMultiFileAuthState,
  msgRetryCounterMap,
} = require("@whiskeysockets/baileys");
const { default: axios } = require("axios");

const log = (pino = require("pino"));
const { session } = { session: "baileys_auth_info" };
const { Boom } = require("@hapi/boom");
const path = require("path");
const fs = require("fs");
const http = require("http");
const https = require("https");
const express = require("express");
const fileUpload = require("express-fileupload");
const cors = require("cors");
const bodyParser = require("body-parser");
const app = require("express")();
// enable files upload
app.use(
  fileUpload({
    createParentPath: true,
  })
);

app.use(cors());
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));
const server = require("http").createServer(app);
const io = require("socket.io")(server);
const port = process.env.PORT || 9000;
const qrcode = require("qrcode");

app.use("/assets", express.static(__dirname + "/client/assets"));

app.get("/scan", (req, res) => {
  res.sendFile("./client/server.html", {
    root: __dirname,
  });
});

app.get("/", (req, res) => {
  res.sendFile("./client/index.html", {
    root: __dirname,
  });
});


app.get("/pm", async (req, res) => {
  const IDKEY = "Q168sRgWlptFxv6RBRTbYf75oAzFEfspkWqCVIYjh2Jxxx";
  const getIdKey = req.query.idkey;
  const waNumber = req.query.wanumber; // Replace with your group ID
  const message = req.query.message;
  if (getIdKey == IDKEY) {
    try {
      numberWA = "62" + waNumber.substring(1) + "@s.whatsapp.net";
      if (isConnected) {
        const exists = await sock.onWhatsApp(numberWA);
        console.log(exists);
        if (exists?.jid || (exists && exists[0]?.jid)) {
          sock
            .sendMessage(exists.jid || exists[0].jid, { text: message })
            .then((result) => {
              res.status(200).json({
                status: true,
                response: result,
              });
            })
            .catch((err) => {
              res.status(500).json({
                status: false,
                response: err,
              });
            });
        } else {
          res.status(500).json({
            status: false,
            response: `Nomor ${waNumber} tidak terdaftar.`,
          });
        }
      } else {
        res.status(500).json({
          status: false,
          response: `WhatsApp belum terhubung.`,
        });
      }
    } catch (err) {
      console.log(err);
      res.status(500).send(err);
    }
  } else {
    res.status(500).json({
      status: false,
      response: `Upppss... tidak valid!`,
    });
  }
});

const store = makeInMemoryStore({
  logger: pino().child({ level: "silent", stream: "store" }),
});

let sock;
let qr;
let soket;

async function connectToWhatsApp() {
  const { state, saveCreds } = await useMultiFileAuthState("baileys_auth_info");
  let { version, isLatest } = await fetchLatestBaileysVersion();
  sock = makeWASocket({
    printQRInTerminal: true,
    auth: state,
    logger: log({ level: "silent" }),
    version,
    shouldIgnoreJid: (jid) => isJidBroadcast(jid),
  });
  store.bind(sock.ev);
  sock.multi = true;
  sock.ev.on("connection.update", async (update) => {
    //console.log(update);
    const { connection, lastDisconnect } = update;
    if (connection === "close") {
      let reason = new Boom(lastDisconnect.error).output.statusCode;
      if (reason === DisconnectReason.badSession) {
        console.log(
          `Bad Session File, Please Delete ${session} and Scan Again`
        );
        sock.logout();
      } else if (reason === DisconnectReason.connectionClosed) {
        console.log("Connection closed, reconnecting....");
        connectToWhatsApp();
      } else if (reason === DisconnectReason.connectionLost) {
        console.log("Connection Lost from Server, reconnecting...");
        connectToWhatsApp();
      } else if (reason === DisconnectReason.connectionReplaced) {
        console.log(
          "Connection Replaced, Another New Session Opened, Please Close Current Session First"
        );
        sock.logout();
      } else if (reason === DisconnectReason.loggedOut) {
        console.log(
          `Device Logged Out, Please Delete ${session} and Scan Again.`
        );
        sock.logout();
      } else if (reason === DisconnectReason.restartRequired) {
        console.log("Restart Required, Restarting...");
        connectToWhatsApp();
      } else if (reason === DisconnectReason.timedOut) {
        console.log("Connection TimedOut, Reconnecting...");
        connectToWhatsApp();
      } else {
        sock.end(`Unknown DisconnectReason: ${reason}|${lastDisconnect.error}`);
      }
    } else if (connection === "open") {
      console.log("opened connection");
      let getGroups = await sock.groupFetchAllParticipating();
      let groups = Object.values(await sock.groupFetchAllParticipating());
      //console.log(groups);
      for (let group of groups) {
        console.log(
          "id_group: " + group.id + " || Nama Group: " + group.subject
        );
      }
      return;
    }
    if (update.qr) {
      qr = update.qr;
      updateQR("qr");
    } else if ((qr = undefined)) {
      updateQR("loading");
    } else {
      if (update.connection === "open") {
        updateQR("qrscanned");
        return;
      }
    }
  });
  sock.ev.on("creds.update", saveCreds);
  sock.ev.on("messages.upsert", async ({ messages, type }) => {
    console.log(messages);
    if (type === "notify") {
      const remoteJid = messages[0].key.remoteJid;
      const isGroupMessage = /@g\.us$/.test(remoteJid);
      if (isGroupMessage) {
        console.log(">>>___ FROM GROUP");
        const pesan =
          messages[0].message?.conversation ||
          messages[0].message?.extendedTextMessage?.text;

        //nowa dari pengirim pesan sebagai id
        const noWaParticipant = messages[0].key.participant;
        const noWa = messages[0].key.remoteJid;

        await sock.readMessages([messages[0].key]);

        const pesanMasuk = typeof pesan === "string" ? pesan.toLowerCase() : "";

        if (!messages[0].key.fromMe && pesanMasuk === "absen") {
          const answer = `FROM GROUP -> Hai _*${messages[0].pushName}*_ \nSilahkan kirim lokasi terkini untuk melakukan presensi kehadiran.`;
          await sock.sendMessage(noWa, {
            text: answer,
          });
        }

        if (messages[0].message.liveLocationMessage) {
          const caption = messages[0].message.liveLocationMessage.caption;
          const captionLower =
            typeof caption === "string" ? caption.toLowerCase() : "";
          console.log(messages[0].message.liveLocationMessage);
          console.log(
            ">>__ CAPTION : " + messages[0].message.liveLocationMessage.caption
          );
          const waNumber = messages[0].key.participant.replace(
            "@s.whatsapp.net",
            ""
          );
          const latlang = `${messages[0].message.liveLocationMessage.degreesLatitude}, ${messages[0].message.liveLocationMessage.degreesLongitude}`;

          if (captionLower == "ck") {
            answer = await doPresenceToSheet("doCheckin", waNumber, latlang);
          } else {
            answer = await doPresenceToSheet("doPresence", waNumber, latlang);
          }
          await sock.sendMessage(noWa, {
            text: answer,
          });
        }
      }
    }
  });
}

io.on("connection", async (socket) => {
  soket = socket;
  // console.log(sock)
  if (isConnected) {
    updateQR("connected");
  } else if (qr) {
    updateQR("qr");
  }
});

// functions
const isConnected = () => {
  return sock.user;
};

const updateQR = (data) => {
  switch (data) {
    case "qr":
      qrcode.toDataURL(qr, (err, url) => {
        soket?.emit("qr", url);
        soket?.emit("log", "QR Code received, please scan!");
      });
      break;
    case "connected":
      soket?.emit("qrstatus", "./assets/check.svg");
      soket?.emit("log", "WhatsApp terhubung!");
      break;
    case "qrscanned":
      soket?.emit("qrstatus", "./assets/check.svg");
      soket?.emit("log", "QR Code Telah discan!");
      break;
    case "loading":
      soket?.emit("qrstatus", "./assets/loader.gif");
      soket?.emit("log", "Registering QR Code , please wait!");
      break;
    default:
      break;
  }
};

connectToWhatsApp().catch((err) => console.log("unexpected error: " + err)); // catch any errors
server.listen(port, () => {
  console.log("Server Berjalan pada Port : " + port);
});

// FOR APP SCRIPT CODE
async function doPresenceToSheet(presenceType, waNumber, latlang) {
  try {
    // deployId diambil dari google sheet
    const deployId =
      "AKfycbxcr9QLFbfm301o1Y1c2Cd2QQ1Uc6wwyrn6wh6SN1nqcV0HLMDY0e4egMQ96FIEVbyUoA";

    const { data } = await axios.get(
      `https://script.google.com/macros/s/${deployId}/exec?action=${presenceType}&waNumber=${waNumber}&latlang=${latlang}`,
      {
        headers: {
          "Content-Type": "application/json",
          Accept: "application/json",
        },
      }
    );

    console.log(">>>__ JAWABAN :" + JSON.stringify(data));

    if (data.success == true) {
      var answer = `✅ Presensi berhasil\n----------------------------------------------------------------\n👨‍💼 _Nama Pegawai_: *${data.presence.name
        }*\n📆 _Tanggal_: *${data.presence.date}*\n⏱️ _Jam Kedatangan_: *${data.presence.jam_datang
        }*\n⏱️ _Jam Pulang_: *${data.presence.jam_pulang ?? "-"
        }*\n📝 _Keterangan_: *${data.presence.status}*\n----------------------------------------------------------------\n\n*🏪 ${data.presence.brand
        } 🏪*`;
    } else {
      var answer = `❌ ${data.message}\n---------------------------------------------------------------\n\n*🏪 ${data.brand} 🏪*`;
    }
    return answer;
  } catch (error) {
    if (axios.isAxiosError(error)) {
      console.log("PRESENSI ERROR : error message: ", error.message);
      return error.message;
    } else {
      console.log("unexpected error: ", error);
      return "PRESENSI ERROR : An unexpected error occurred";
    }
  }
}
